% Dataset of Grice et al. (1999) of 280 children taking 
% the Wechsler III test. Also used in Grice (2001) and Stegeman (2015).

% Grice, J.W., Krohn, E.J., & Logerquist, S. (1999). Cross-validation of 
% the WISC-III factor structure in two samples of children with learning 
% disabilities. Journal of Psychoeducational Assessment, 17, 236-248.

% Grice, J.W. (2001). Computing and evaluating factor scores. Psychological 
% Methods, 6, 430-450.
%
% Stegeman, A. (2016). A new method for simultaneous estimation of the 
% factor model parameters, factor scores, and unique parts.


X=[8 6 3 13 4 5 11 12 7 7 6 13
11 9 3 8 6 7 8 8 9 6 5 8
 3 4 5 6 5 7 7 4 8 6 10 7
 1 9 5 14 9 5 9 10 13 9 7 6
 7 11 9 11 5 11 9 10 11 11 13 10
 6 5 5 5 6 4 12 2 10 6 9 6
 9 10 9 13 5 11 6 9 7 13 11 9
10 10 10 11 12 12 12 11 11 8 16 7
10 6 11 8 12 14 8 8 4 12 17 7
 1 6 7 6 4 7 4 3 1 7 10 6
 9 2 7 5 7 7 11 5 7 6 10 5
 8 8 9 5 10 7 10 6 13 3 14 4
 3 7 14 8 6 10 1 7 1 6 9 7
 4 5 4 6 3 9 6 5 5 8 8 8
10 5 8 8 4 6 10 2 11 8 7 8
11 7 9 6 6 8 2 7 3 6 8 9
 9 5 13 13 7 9 7 8 13 11 13 6
12 11 11 15 10 8 12 14 14 12 16 6
13 9 13 9 11 10 11 12 12 8 19 7
12 12 11 12 12 7 10 11 8 9 11 6
 9 9 6 8 6 13 6 5 8 5 12 9
13 14 6 12 5 10 10 13 14 11 10 10
 8 8 6 7 7 9 7 10 5 10 7 10
 8 9 7 8 11 9 9 6 13 10 15 9
 1 2 3 7 2 8 3 6 2 9 4 11
 7 8 5 9 10 8 9 10 9 4 10 8
 7 7 10 9 11 12 7 10 11 7 9 8
 9 8 16 13 13 8 12 12 7 11 9 8
 8 4 7 5 8 5 8 7 8 2 12 4
11 11 8 14 10 6 10 9 5 10 6 9
10 8 7 8 8 5 9 5 9 8 9 5
 8 7 4 9 5 4 4 8 5 8 5 9
 7 7 8 8 13 13 9 8 17 6 10 7
 6 5 8 6 10 5 9 6 5 1 5 7
 6 10 5 9 8 8 10 9 4 8 9 8
15 14 5 14 9 9 9 15 5 10 11 11
 8 11 10 8 10 8 7 5 6 5 13 7
 6 6 10 8 3 3 8 4 10 3 11 11
 7 6 10 7 10 10 10 7 5 8 8 10
 2 8 6 9 9 6 4 5 5 6 10 6
 8 12 2 9 6 8 7 9 11 9 11 11
 6 3 1 7 4 8 4 8 3 8 2 10
 9 13 5 12 10 13 10 9 5 4 7 7
 9 7 12 9 9 5 9 10 6 9 9 11
 6 11 8 10 10 5 6 11 4 16 7 12
 6 8 8 4 10 5 5 5 8 8 8 14
 8 7 4 7 1 6 3 8 7 8 4 5
14 4 9 7 14 6 12 7 10 8 9 8
 7 10 8 10 7 9 3 8 9 13 9 8
 8 10 3 12 11 3 5 10 8 5 6 7
11 6 9 8 10 5 5 7 13 9 8 8
 6 10 15 6 5 13 9 9 7 13 12 9
 9 9 8 6 11 12 13 8 12 6 7 13
10 15 11 12 11 8 13 13 7 9 11 8
 8 13 13 11 6 9 8 10 8 11 12 13
14 5 9 11 11 10 16 11 9 11 6 10
 6 5 4 9 7 4 7 8 9 9 10 9
 9 9 5 12 13 9 8 10 11 10 14 8
 8 7 11 6 8 9 8 7 8 9 12 8
10 8 10 5 9 11 11 6 9 8 10 12
 8 7 4 8 2 8 7 1 6 8 10 7
 7 10 7 8 8 10 10 9 9 10 5 13
 8 9 4 11 9 8 9 9 10 9 8 8
10 12 13 7 12 7 9 9 10 11 13 8
11 10 8 11 10 10 11 7 11 13 8 8
 8 5 9 7 7 7 8 3 9 5 12 8
11 9 12 8 8 3 8 5 7 8 12 6
12 11 9 7 9 2 10 9 10 7 12 8
 5 8 5 8 1 9 7 8 7 8 10 7
 9 12 6 13 10 11 9 12 9 13 7 6
15 9 5 8 8 8 10 9 6 10 8 5
10 7 7 11 11 4 17 8 16 10 8 9
 3 8 9 6 3 7 2 6 1 8 8 7
 9 9 10 10 8 9 11 7 9 10 10 7
10 6 10 11 11 10 10 9 10 6 12 8
11 5 11 5 11 7 10 2 8 9 13 7
 4 4 8 9 7 9 11 7 8 7 9 10
12 7 11 6 10 8 10 4 9 6 12 9
13 7 11 10 9 7 12 11 12 4 7 6
 7 12 7 13 7 6 10 7 9 9 4 9
 5 5 2 9 4 4 5 3 6 6 6 7
10 9 5 7 9 3 10 9 14 10 7 9
 7 12 7 13 7 6 10 7 9 9 4 8
11 8 1 8 5 6 8 4 6 5 7 4
10 10 10 12 13 9 10 11 10 7 12 8
 8 5 10 12 11 6 9 9 9 10 8 6
 8 5 10 6 8 9 10 8 8 12 7 7
 7 14 4 13 7 5 6 12 4 8 3 8
11 14 10 14 16 12 17 10 8 14 13 11
 9 14 13 10 11 10 9 12 7 14 18 6
 7 8 13 11 14 7 10 10 9 11 17 9
 5 6 8 6 5 7 4 5 5 7 7 2
 4 5 12 10 9 8 9 9 8 11 8 9
12 5 9 5 12 9 11 9 13 7 9 6
 9 7 12 3 10 10 12 5 11 8 10 8
 5 8 8 6 4 8 5 5 1 9 6 12
 9 9 11 7 12 11 9 12 9 11 18 7
13 10 10 6 9 9 8 10 8 10 12 12
 6 6 5 10 10 6 2 10 5 12 11 10
13 10 10 9 7 6 10 10 16 9 11 8
 4 8 5 11 6 9 8 12 7 8 10 11
 8 5 11 6 10 5 7 2 11 7 14 6
11 11 10 7 7 8 13 9 9 11 10 13
 6 5 8 7 10 8 5 5 5 7 5 8
 5 4 14 8 7 7 6 7 1 6 10 3
10 7 9 4 7 5 10 9 3 6 9 4
11 9 7 9 8 10 4 6 10 7 7 14
 4 6 7 2 4 6 1 1 2 8 5 6
 5 5 9 6 9 12 5 6 2 8 3 7
 4 6 4 8 9 5 10 9 13 11 4 8
 5 5 5 5 4 3 6 6 7 3 10 7
 6 15 11 10 3 11 4 14 9 13 11 6
 2 12 5 8 9 8 6 8 5 12 6 8
 1 10 10 6 11 9 6 7 11 9 11 7
 9 11 13 7 17 9 10 10 9 10 13 11
10 17 14 14 16 11 9 13 7 17 19 13
 8 8 8 5 7 5 2 6 7 8 7 4
 8 5 12 5 12 8 6 4 11 9 12 4
12 6 8 7 10 3 10 8 9 8 7 9
11 11 14 9 17 8 10 11 5 13 15 8
10 13 12 11 17 9 5 12 7 10 14 4
10 6 15 7 13 8 12 6 9 9 18 11
 8 12 7 12 8 9 4 8 5 14 10 8
10 11 13 16 11 14 12 12 6 10 11 11
14 4 9 10 11 6 13 9 11 11 11 7
 9 14 11 9 11 9 12 13 9 15 10 13
 8 6 11 10 7 9 4 5 5 9 7 4
 9 9 4 7 8 7 10 6 12 5 6 7
 5 6 3 8 9 11 4 2 7 4 9 8
10 12 10 10 5 6 5 9 12 4 14 4
 7 8 8 6 8 9 8 7 8 4 9 7
10 9 10 8 5 10 9 7 9 3 11 8
 9 5 7 9 5 5 11 8 7 8 11 6
11 8 13 11 13 9 8 10 8 11 10 11
12 5 14 6 11 6 11 5 16 4 11 12
12 12 14 13 16 9 16 10 13 10 13 5
 4 8 11 8 7 6 2 6 4 6 7 8
 8 7 7 6 5 4 1 6 5 6 6 5
 9 8 6 6 4 9 2 6 8 6 7 11
 9 6 8 7 9 5 9 6 10 6 11 8
 8 8 10 7 9 4 6 6 2 7 9 8
 8 10 4 11 3 10 5 9 1 12 10 8
 9 9 8 9 11 4 9 8 12 7 11 6
 8 8 7 7 12 4 4 5 8 7 8 4
12 7 8 1 11 9 15 12 11 13 11 8
 9 9 8 8 5 6 6 7 9 11 3 13
10 7 11 8 6 5 8 6 11 8 8 8
 8 6 12 8 10 8 5 7 6 12 7 7
14 10 10 14 8 7 12 13 16 13 10 11
10 7 8 10 11 9 12 9 11 8 11 15
 9 9 12 7 2 7 6 8 9 8 10 7
13 14 9 14 12 12 18 10 15 15 10 12
11 12 14 15 12 11 15 15 12 13 13 7
11 10 9 8 9 8 9 8 10 8 8 8
11 8 10 19 8 5 9 7 8 8 11 10
 9 12 7 10 7 10 11 10 12 11 12 6
13 13 8 11 15 12 10 12 11 14 11 8
10 12 19 9 7 7 17 10 12 11 11 7
13 9 12 11 10 6 11 7 9 9 10 8
13 14 8 13 10 11 10 12 12 12 11 14
 9 9 9 11 8 7 13 8 13 9 12 6
12 11 9 12 8 10 12 10 7 13 10 9
16 8 15 11 12 6 16 10 15 11 13 8
 9 4 7 8 5 5 6 5 8 8 8 11
 9 12 5 10 7 7 6 11 8 10 7 9
 8 11 8 14 10 8 9 13 8 11 9 6
11 8 10 9 15 8 10 9 11 10 13 9
 7 7 11 12 11 10 8 11 6 7 10 7
12 6 9 13 11 9 6 8 12 8 9 5
10 13 9 15 8 9 8 10 6 12 11 14
 8 8 9 7 13 4 10 9 11 13 7 5
16 10 8 11 15 8 11 10 9 13 9 9
 8 7 7 8 6 5 1 7 2 8 7 7
 8 6 9 9 7 10 9 7 7 7 6 12
12 14 12 11 13 11 12 7 8 10 11 13
 6 8 10 7 5 6 7 7 9 4 7 7
 9 6 11 6 8 9 5 4 9 7 7 8
11 9 12 7 8 11 12 7 9 12 12 10
10 10 8 7 12 8 10 8 9 5 11 7
 6 7 7 9 8 8 8 6 4 8 8 11
 3 7 7 6 1 5 1 5 1 5 9 9
10 8 8 11 10 4 4 5 4 9 6 5
11 12 17 11 11 11 14 12 13 11 14 7
 9 9 10 10 12 10 7 7 9 8 13 13
 8 4 14 7 1 4 5 4 3 4 12 9
14 12 14 13 10 11 19 11 14 13 14 12
10 10 10 12 12 6 10 11 8 10 11 8
 9 9 8 11 8 9 10 10 10 12 8 12
10 6 6 7 5 7 9 7 8 10 9 8
 2 7 11 10 6 8 7 7 1 9 6 7
 7 6 7 8 7 11 10 8 8 7 13 12
 9 13 5 13 14 12 11 13 13 13 10 6
15 12 9 11 11 11 12 9 13 11 10 5
 6 10 10 5 10 6 11 7 9 8 11 10
11 7 19 9 9 9 6 8 6 10 14 8
11 11 10 14 10 11 11 12 10 17 10 9
15 9 13 9 7 6 9 7 13 9 12 7
 6 9 2 9 1 8 1 10 5 11 5 8
 9 11 5 8 9 9 8 6 1 9 6 10
13 10 9 11 14 9 15 10 12 15 13 6
 8 12 7 11 6 4 1 9 9 9 6 8
14 13 10 7 11 12 13 12 11 5 11 9
 8 7 10 6 6 9 2 3 6 7 11 11
 8 7 6 8 7 4 2 6 4 7 9 10
12 13 10 11 4 9 6 9 13 13 7 10
 9 4 14 6 8 7 7 4 7 6 9 8
10 11 7 12 9 11 12 16 8 13 13 10
 7 5 6 7 6 5 11 6 7 8 8 6
 7 5 7 7 7 5 5 4 10 7 9 6
14 10 8 9 4 7 14 7 9 9 6 12
13 13 9 11 6 8 8 10 8 8 7 7
12 10 5 12 7 6 6 9 8 9 7 6
 9 5 11 7 6 6 4 5 5 7 12 6
15 13 7 13 10 11 12 9 15 18 13 7
12 9 8 12 15 7 11 10 15 9 11 10
11 8 10 11 8 9 8 9 11 13 9 8
11 10 8 10 13 12 12 11 13 11 14 11
10 8 12 8 4 7 8 6 10 8 5 14
 6 12 8 10 8 8 7 11 6 12 12 11
 9 5 7 7 8 7 8 8 9 9 9 10
 6 9 8 10 4 6 4 8 5 7 9 5
12 14 7 14 11 9 14 10 11 12 12 9
12 13 6 8 9 11 11 8 10 9 6 9
 8 11 7 10 6 7 10 8 9 14 10 9
 9 9 8 9 10 9 7 8 9 10 11 7
 8 8 10 9 8 8 7 8 10 6 6 7
 7 10 9 11 9 11 9 10 9 8 15 15
 6 7 14 11 14 9 6 8 8 11 14 5
 7 9 10 8 4 9 8 10 9 8 10 9
 8 4 9 7 6 4 7 3 8 4 10 7
10 10 8 16 14 8 8 12 10 14 9 11
 9 9 5 11 8 11 8 8 5 10 4 11
 7 7 4 5 1 7 4 7 8 3 5 4
12 11 13 12 11 10 12 10 9 10 14 12
10 5 7 8 13 6 12 6 14 11 10 9
 8 12 10 12 8 7 12 10 12 11 10 5
 7 6 8 9 10 9 8 5 8 8 11 7
 8 7 11 8 9 5 7 11 10 8 12 7
15 10 9 14 12 8 14 11 14 9 12 8
 8 9 7 8 6 5 11 7 9 8 9 4
10 8 14 7 10 10 18 6 12 10 12 10
13 13 7 11 7 8 9 11 11 9 9 9
12 12 6 11 6 10 12 9 12 10 8 13
 5 12 8 13 8 8 10 10 9 11 10 6
11 8 10 11 14 11 18 8 13 8 14 13
 6 4 13 7 4 7 10 5 12 2 10 8
12 13 9 11 11 9 15 11 13 18 8 9
 9 8 10 9 11 10 10 2 10 11 14 4
11 13 14 8 12 12 18 7 11 10 14 7
15 10 9 11 12 11 16 11 16 11 16 12
10 12 12 9 10 12 13 10 5 17 15 13
 8 10 11 9 3 10 9 7 11 8 11 7
11 6 7 8 5 10 11 9 7 14 9 12
 7 8 6 8 10 4 11 8 11 11 9 5
 8 5 5 10 5 4 9 5 11 7 5 6
 8 10 6 6 7 7 4 10 10 8 7 3
 6 9 12 10 6 9 8 8 3 6 10 8
11 9 16 9 16 10 11 8 11 12 12 8
10 10 11 8 12 10 8 9 7 10 12 6
11 6 8 9 7 7 6 8 8 8 10 7
 7 6 5 8 8 7 5 7 8 8 8 9
 8 10 4 10 7 11 8 9 9 11 1 9
13 9 7 10 11 12 11 12 13 11 11 6
 9 6 14 9 8 8 8 5 9 10 12 11
10 6 11 7 8 4 9 6 10 4 9 7
 4 3 7 8 7 6 1 5 7 5 9 8
 7 9 9 12 9 10 12 10 5 13 13 10
 9 8 10 8 5 6 10 9 10 7 12 6
10 16 3 13 7 11 8 17 9 16 10 9
10 15 10 10 10 6 14 12 15 6 14 9
16 11 8 12 12 7 15 8 12 7 7 6
12 5 7 9 11 5 8 7 8 7 11 7
13 8 10 4 11 12 8 5 11 7 5 6
11 8 15 8 6 8 5 6 10 6 11 8
 8 8 4 8 6 8 7 6 8 9 5 6
 8 5 7 1 5 7 3 4 8 6 7 6
11 7 5 10 10 5 10 6 9 11 11 7
16 7 5 10 11 7 9 9 11 10 8 8
15 9 7 16 10 1 10 12 16 12 10 5
 7 10 6 10 12 5 8 9 17 8 2 7];

% standardize data
[n,k]=size(X);
Y=X-ones(n,n)*X/n;
Y=Y*inv(sqrt(diag(diag(Y'*Y/n))));
S=Y'*Y/n;

% fit Data Factor Model II and do Varimax rotation
r=4;
[F,Fd,P,E,Ed,U,comm,ecv,ecv_total,fptot,mincorr] = DFM2(Y,r,1);

[P2,T,f]=varim(P);
Fd2=Fd*T;
F2=F*T;
mincorr2=2*diag(Fd2'*Fd2)/n-1;

% sign changes in P2, F2 and Fd2 such that largest entry per column in P2 is positive
temp=sort(P2./(ones(k,1)*max(abs(P2))));
signs=ones(1,r)-2*(temp(1,:)==-1);
P2=P2*diag(signs);      
F2=F2*diag(signs);
Fd2=Fd2*diag(signs);

% After rotation we obtain loadings P2, factor scores F2 with determinate part Fd2,
% and minimal correlations mincorr2. Note: for comparison with the results 
% in Stegeman (2016), column permutations may be needed in P2 and F2 simultaneously.
                                 
                                 
% generate 10000 realisations of indeterminate part Fu and plot factor
% score densities for subject 1 (section 4.4 of Stegeman, 2016)
[Q4,Psi2,temp]=svd(S-U*U,0);
Psi=Psi2^0.5;
Q4r=Q4(:,1:r);
Psir=Psi(1:r,1:r);
[Q5,Gam,temp]=svd(eye(k)-U*inv(S)*U,0);

G=orth(null([Y ones(n,1)]')); 

Fd3=(Y-Ed*U)*Q4r*inv(Psir);
P3=Q4r*Psir;
T2=procrustes(P3,P2);

num=10000;
Fsim=zeros(num,n,r);
for i=1:num
    [Q,R]=qr(randn(size(G,2),k),0);
    M=Q*diag(sign(diag(R)));            
    Eu=sqrt(n)*G*M*(Gam^0.5)*Q5';
    Fu=-Eu*U*Q4r*inv(Psir);
    F3=Fd3+Fu;
    F3=F3*T2;
    Fsim(i,:,:)=F3;
end

factor_score_density(Fsim,Fd2,1);
