function [u,v]=ed(s);
% [u,v]=ed(s);
%
% Gives SORTED eigenvalues in v, associated NORMALIZED eigenvectors in u
%
% NOTE: Giving only "ed(s)" produces EIGENVECTORS only 
% To get ONLY sorted EIGENVALUES use "eiv"
%
% The rank is determined numerically, dropping eigenvalues
% that are less then a predetermined tolerance (1e-9).
% Associated eigenvectors are eliminated.

tol=eps;
[u,v]=eig(s);
v=diag(v);
% i=abs(v)>tol;
% u=u(:,i);
% v=v(i);
p=length(v);
[v,i]=sort(v);
j=p:-1:1;
v=v(j);
v=diag(v);
u=u(:,i(j));
u=nrm(u);
