function factor_score_density(Fsim,Fd,i);

% Plots factor score densities due to indeterminacy for subject i when factor score
% realisations are in Fsim of size #realisations x #subjects x #factors.
% Vertical lines are plotted at the determinate factor scores, which are
% given in Fd of size #subjects x #factors.

[num,n,r]=size(Fsim);
figure
for j=1:r
    subplot(r,1,j);
    ksdensity(Fsim(:,i,j))
    [f,x]=ksdensity(Fsim(:,i,j));
    hold on
    plot([Fd(i,j) Fd(i,j)],[0 max(f)],'r')
    s1='Factor score density for subject ';
    s2=int2str(i);
    s3=', factor ';
    s4=int2str(j);
    s=strcat({s1},{s2},{s3},{s4});
    title(s,'FontWeight','normal')
    axis([-3 3 0 1.5])
end

