function [gamma,iter,T]=glb(C,conv,T);
% function [gamma,iter]=glb(C,conv,T);
% routine glb
%
% input: C covariance/correlation matrix
%	 conv=convergence criterion
%	 T for start (can be omitted)
%
% uses tr.m nrm.m

[m,m]=size(C);
if nargin<=2
  T=nrm(randn(m,m));	% T denotes T_prime in Ten Berge, et al. 81
end;
C0=C-diag(diag(C));

labda0=0;
iter=0;
f=trace(T*C*T');
fold=f+2*conv;
labda=-10000;
extra=0;
iterextra=0;
gamma=zeros(m,1);

while ((fold-f>conv) | (labda<-.1*conv))
  fold=f;
  iter=iter+1;
  iterextra=iterextra+1;
  for i=1:m
    yi=T*C0(:,i);
    delta=(yi'*yi)^.5;
    if delta==0
      T(:,i)=nrm(T(:,i));
    end;
    if ((delta>0) & (delta<C(i,i)))
      T(:,i)=-yi/delta;
    end;
    if delta>=C(i,i)
      T(:,i)=-yi/C(i,i);
    end;
  end;
  f=trace(T*C*T');
%  if iter/100==round(iter/100), fprintf('function value = %12.8f after %g iters \n',f,iter);end;
  if (fold-f)<=conv & (extra==0)		% if function value converged, check smallest eigenvalue
    tt=sum(T.^2);    
    w=tt<=1.0000000001;
    gamma=diag(C);
    gg=diag(C0*T'*T*C0);
    gamma(w)=gg(w).^.5;
    labda=min(eig(C0+diag(gamma)));
    if labda<-.1*conv
      extra=1;
      iterextra=0;
    end;
  end;

  if ((extra==1) & (round((iterextra+1)/10)==(iterextra+1)/10))
    tt=sum(T.^2);    
    w=tt<=1.0000000001;
    gamma=diag(C);
    gg=diag(C0*T'*T*C0);
    gamma(w)=gg(w).^.5;
    labda0=labda;
    labda=min(eig(C0+diag(gamma)));     % reevaluate labda only once every ten full cylces
    if abs(labda-labda0)<.0001*abs(labda0)
      disp('Too small improvements; restart T');
      T=nrm(randn(m,m));	
      extra=0;
      extraiter=0;
      f=trace(T*C*T');
    end;
  end;
end;     
tt=sum(T.^2);    
w=tt<=1.0000000001;
gamma=diag(C);
gg=diag(C0*T'*T*C0);
gamma(w)=gg(w).^.5;
labda=min(eig(C0+diag(gamma))); % reevaluate labda only once every ten full cylces
if labda<-.1*conv,beep,disp('too negative eigenvalue');disp(labda);end;
%disp('check1');
%disp( C0*T'+diag(gamma)*T' );
%disp('check2; eigenvalues of C0+Gamma');
%eiv(C0+diag(gamma))	% reevaluate labda only once every ten full cylces


