function [comm,errvar,f]=mrfa(C,r,conv1,conv2)

% Computes optimal unique variances under MRFA.
%
% Ten Berge, J.M.F., & Kiers, H.A.L. (1991). A numerical approach to the 
% approximate and the exact minimum rank of a covariance matrix. 
% Psychometrika, 56, 309-315.
%
% Input: C = covariance matrix
%	 r = dimensionality
%	 conv1= overall convergence criterion
%	 conv2= inner iterations (glb) convergence criterion
%        start= 1 random ; other: self given
% Output:   comm = optimal communalities
%           errvar = optimal unique variances 
%	 f = mrfa function value
%
% uses glb.m ed.m nrm.m

[m,m]=size(C);

% initializations

start=1;
nstarts=3;
%nstarts=1;
%if start==1
%  nstarts=input('How many random starts?');
%end;

func=zeros(nstarts,1);
GAM=zeros(m,nstarts);

for ana=1:nstarts

 if start==1
  rng('shuffle');
  gam=rand(m,1);
  T=nrm(randn(m,m));
 end; 

 % computation start function value

 Cg=C-diag(diag(C))+diag(gam);
 [K,L]=ed(Cg);
 l=diag(L);
 f=sum(l(r+1:m));
 fprintf(' Unexplained Common Variance at start is %12.8f \n',f);
 fold=f+2*conv1*f;
 iter=0;

 while (((fold-f)>f*conv1) & (f>.01*conv1)) | (iter<2);
  fold=f;
  iter=iter+1;
  if r<m-1,w=(sum((K(:,r+1:m).^2)')').^.5;end;
  if r==m-1,w=(K(:,r+1:m).^2).^.5;end;
  Sigma=(w*w').*C;
  [gam,initer,T]=glb(Sigma,conv2,T);	% glb step
  gam=gam./(w.^2);
  Cg=C-diag(diag(C))+diag(gam);
  [K,L]=ed(Cg);
  l=diag(L);

  % correction of gamma`s because of negative eigenvalues 
  if l(m)<0
    gam=gam-l(m);  
    l=l-l(m);
    if l(m)<-.1,fprintf('correction factor= %12.8f \n',l(m));end;
  end;

  f=sum(l(r+1:m));
  fprintf('mrfa value is %12.8f after %g iters (and %g inner iters) \n',f,iter,initer);
 end;
 func(ana)=f;
 GAM(:,ana)=gam;
end;
[f,mi]=min(func);
comm=GAM(:,mi);
errvar=diag(C)-comm;
