function T=procrustes(A1,A2);

% usage: T=procrustes(A1,A2)
% computes orthonormal rotation T such that ssq(A1*T-A2) is minimal
% Note: A1 and A2 have the same size, and are square or vertical matrices
%
% See: Ten Berge (1977), Psychometrika, 267-276.

[P,D,Q]=svd(A1'*A2,0);
T=P*Q';

