function    [S,T,U,G,error_ssq]=CP2blocks(A,B,C,L);

% usage:    [S,T,U,G,error_ssq]=CP2blocks(A,B,C,L);
%
% input:    CP decomposition (A,B,C)
%           block sizes in vector L 
%           r=sum(L) equals the number of components 
%    
% output:   constrained Tucker3 model (S,T,U,G) with unfolded core array G
%           G has size rxrxr and is block diagonal
%           each block has upper triangular slices
%
% uses:     ql.m
%
% code by   Alwin Stegeman, a.w.stegeman@rug.nl
%
% refs:     A. Stegeman (2012). Candecomp/Parafac, from diverging components
%           to a decomposition in block terms. SIAM Journal on Matrix
%           Analysis and Applications, 33, 291-316.
%
%           A. Stegeman (2013). A three-way Jordan canonical form as limit 
%           of low-rank tensor approximations. SIAM Journal on Matrix 
%           Analysis and Applications, 34, 624-650.

n=length(L);
r=length(A(1,:));
mat=length(C(:,1));

Y=[];
for k=1:mat
    Y=[Y A*diag(C(k,:))*B'];
end

S=[];
T=[];
U=[];
G=zeros(r,r*r);
s=0;

for j=1:n
    k=L(j);
    s=s+k;
    Aj=A(:,s-k+1:s);
    Bj=B(:,s-k+1:s);
    Cj=C(:,s-k+1:s);
    if k==1
        S=[S Aj];
        T=[T Bj];
        U=[U Cj];
        G(s:s,(s-1)*r+s:(s-1)*r+s)=1;
    end;
    if k>1
        [Qa,Ra]=qr(Aj,0);
        [Qb,Lb]=ql(Bj);
        S=[S Qa];
        T=[T Qb];
        Rk=[];
        for i=1:mat
            Rk=[Rk Ra*diag(Cj(i,:))*Lb'];
        end
        
        H=[];
        for row=1:k
            for col=row:k
                h1=[];
                for rowh=1:mat
                    h1=[h1;Rk(row,(rowh-1)*k+col)];
                end
                H=[H h1];
            end
        end
        [Uj,Sj,Vj]=svd(H);
        U=[U pinv(Uj(:,1:k))'];
        
        Rj=[];
        for i=1:k
            tmp=zeros(k,k);
            for f=1:mat
                tmp=tmp+Uj(f,i)*Rk(:,(f-1)*k+1:f*k);
            end
            Rj=[Rj tmp];
        end
        
        for i=1:k
            G(s-k+1:s,(s-k+i-1)*r+s-k+1:(s-k+i-1)*r+s)=Rj(:,(i-1)*k+1:i*k);
        end
    end
end


error_ssq=ssq(Y-S*G*kron(U',T'));
    
    
    
    
    
    