function [A0,B0,C0,G0]=blocks2init(S,T,U,G,L);

% usage:    [A0,B0,C0,G0]=blocks2init(S,T,U,G,L);
%
% computes initial values (A0,B0,C0,G0) for CP_limit, i.e. the Tucker3 model with
% block diagonal core G0 and blocks in canonical form with rank > size
%
% input:    Tucker3 model (S,T,U,G) with core G block diagonal
%           each block has upper triangular slices
%           vector L contains block sizes (1,2,3,4 only)
%
% output:   CP_limit initial values as Tucker3 model (A0,B0,C0,G0)
%
% code by   Alwin Stegeman, a.w.stegeman@rug.nl
%
% refs:     A. Stegeman (2012). Candecomp/Parafac, from diverging components
%           to a decomposition in block terms. SIAM Journal on Matrix
%           Analysis and Applications, 33, 291-316.
%
%           A. Stegeman (2013). A three-way Jordan canonical form as limit 
%           of low-rank tensor approximations. SIAM Journal on Matrix 
%           Analysis and Applications, 34, 624-650.

A=S;B=T;C=U;
Y=A*G*kron(C',B');

r=length(G(:,1));

s=0;
for j=1:length(L)
    k=L(j);
    s=s+k;
    A1=A(:,s-k+1:s);
    B1=B(:,s-k+1:s);
    C1=C(:,s-k+1:s);
    G1=zeros(k,k*k);
    for i=1:k
        G1(:,(i-1)*k+1:i*k)=G(s-k+1:s,(s-k+i-1)*r+s-k+1:(s-k+i-1)*r+s);
    end
    if k==2
        S=inv(G1(:,1:2));
        A1=A1*G1(:,1:2);
        G1=S*G1;
        u=(G1(1,3)+G1(2,4))/2;  % mean of diagonal of slice 2
        G1(1,3)=0;
        G1(2,4)=0;
        C1=C1*inv([1 0;-u 1]);  % slicemix
        A(:,s-1:s)=A1;
        B(:,s-1:s)=B1;
        C(:,s-1:s)=C1;
        G(s-1:s,(s-2)*r+s-1:(s-2)*r+s)=G1(:,1:2);
        G(s-1:s,(s-1)*r+s-1:(s-1)*r+s)=G1(:,3:4);
    end
    if k==3
        S=inv(G1(:,1:3));
        A1=A1*G1(:,1:3);
        G1=S*G1;
        u=(G1(1,4)+G1(2,5)+G1(3,6))/3;     % mean of diagonal slice 2
        v=(G1(1,7)+G1(2,8)+G1(3,9))/3;     % mean of diagonal slice 3
        G1(1,4)=0;G1(2,5)=0;G1(3,6)=0;
        G1(1,7)=0;G1(2,8)=0;G1(3,9)=0;
        C1=C1*inv([1 0 0;-u 1 0;-v 0 1]);   % slicemix
        u=((G1(1,8)/G1(1,5))+(G1(2,9)/G1(2,6)))/2;
        G1(:,7:9)=G1(:,7:9)-u*G1(:,4:6);
        G1(1,8)=0;G1(2,9)=0;
        C1=C1*inv([1 0 0;0 1 0;0 -u 1]);    % slicemix
        u=G1(1,6)/G1(1,9);
        G1(1,6)=0;
        C1=C1*inv([1 0 0;0 1 -u;0 0 1]);    % slicemix
        A(:,s-2:s)=A1;
        B(:,s-2:s)=B1;
        C(:,s-2:s)=C1;
        G(s-2:s,(s-3)*r+s-2:(s-3)*r+s)=G1(:,1:3);
        G(s-2:s,(s-2)*r+s-2:(s-2)*r+s)=G1(:,4:6);
        G(s-2:s,(s-1)*r+s-2:(s-1)*r+s)=G1(:,7:9);
    end
    if k==4
        S=inv(G1(:,1:4));
        A1=A1*G1(:,1:4);
        G1=S*G1;
        u=(G1(1,5)+G1(2,6)+G1(3,7)+G1(4,8))/4;  % mean of diag. slice 2
        v=(G1(1,9)+G1(2,10)+G1(3,11)+G1(4,12))/4; % mean of diag. slice 3
        w=(G1(1,13)+G1(2,14)+G1(3,15)+G1(4,16))/4; % mean of diag. slice 4
        G1(1,5)=0;G1(2,6)=0;G1(3,7)=0;G1(4,8)=0;
        G1(1,9)=0;G1(2,10)=0;G1(3,11)=0;G1(4,12)=0;
        G1(1,13)=0;G1(2,14)=0;G1(3,15)=0;G1(4,16)=0;
        C1=C1*inv([1 0 0 0;-u 1 0 0;-v 0 1 0;-w 0 0 1]);  % slicemix
        u=(G1(1,10)/G1(1,6)+G1(2,11)/G1(2,7)+G1(3,12)/G1(3,8))/3;
        v=(G1(1,14)/G1(1,6)+G1(2,15)/G1(2,7)+G1(3,16)/G1(3,8))/3;
        G1(:,9:12)=G1(:,9:12)-u*G1(:,5:8);
        G1(:,13:16)=G1(:,13:16)-v*G1(:,5:8);
        G1(1,10)=0;G1(2,11)=0;G1(3,12)=0;
        G1(1,14)=0;G1(2,15)=0;G1(3,16)=0;
        C1=C1*inv([1 0 0 0;0 1 0 0;0 -u 1 0;0 -v 0 1]);  % slicemix
        u=G1(2,8)/G1(2,12);
        v=(G1(1,15)/G1(1,11)+G1(2,16)/G1(2,12))/2;
        G1(:,5:8)=G1(:,5:8)-u*G1(:,9:12);
        G1(:,13:16)=G1(:,13:16)-v*G1(:,9:12);
        G1(2,8)=0;G1(1,15)=0;G1(2,16)=0;
        C1=C1*inv([1 0 0 0;0 1 -u 0;0 0 1 0;0 0 -v 1]);  % slicemix
        u=G1(1,8)/G1(1,16);
        v=G1(1,12)/G1(1,16);
        G1(1,8)=0;G1(1,12)=0;
        C1=C1*inv([1 0 0 0;0 1 0 -u;0 0 1 -v;0 0 0 1]); % slicemix
        A(:,s-3:s)=A1;
        B(:,s-3:s)=B1;
        C(:,s-3:s)=C1;
        G(s-3:s,(s-4)*r+s-3:(s-4)*r+s)=G1(:,1:4);
        G(s-3:s,(s-3)*r+s-3:(s-3)*r+s)=G1(:,5:8);
        G(s-3:s,(s-2)*r+s-3:(s-2)*r+s)=G1(:,9:12);
        G(s-3:s,(s-1)*r+s-3:(s-1)*r+s)=G1(:,13:16);
    end
end

A0=A;B0=B;C0=C;G0=G;

%ssq(Ai*Gi*kron(Ci',Bi')-Y)     % error ssq due to imposing canonical forms

