function [Q,L]=ql(A)

% usage: [Q,L]=ql(A)
%
% A (n x m) has full column rank
% decomposes  A=Q*L  with Q (n x m) orthonormal columns
% and L (m x m) lower triangular
%
% code by Alwin Stegeman, a.w.stegeman@rug.nl


[n,m]=size(A);

% the procedure below uses Gram-Schmidt

Q=zeros(n,m);
L=zeros(m,m);

for col=m:-1:1
    proj=zeros(n,1);
    for j=col+1:m
        L(j,col)=(Q(:,j)'*A(:,col));
        proj=proj+L(j,col)*Q(:,j);
    end;
    Q(:,col)=A(:,col)-proj;
    L(col,col)=sqrt(Q(:,col)'*Q(:,col));
    Q(:,col)=Q(:,col)/L(col,col);
end;




% the alternative procedure below uses Householder reflections

%L=A;
%Qt=eye(n);
%
%for col=m:-1:1
%    x=L(1:n-m+col,col);
%    EYE=eye(n-m+col);
%    unitvec=EYE(:,n-m+col);
%    v=x+sign(x(1))*sqrt(x'*x)*unitvec;
%    v=v/sqrt(v'*v);
%    w=[v;zeros(m-col,1)];
%    P=eye(n)-2*w*w';
%    L=P*L;
%    Qt=P*Qt;
%end;
%    
%Q=Qt';
%
%if (n>m)
%    Q=Q(:,n-m+1:n);
%    L=L(n-m+1:n,:);
%end;
%
%L=tril(L);

