% Dataset of rescaled correlation matrices of 12 tests for high school children:
%
% 1. Vocabulary
% 2. Information I
% 3. Information II
% 4. Spelling
% 5. Punctuation
% 6. English Usage
% 7. Mechanical Reasoning
% 8. Visualization I
% 9. Visualization II
% 10. Table Reading
% 11. Clerical Checking
% 12. Object Inspection
%
% The dataset is split into four groups based on IQ and SES:
%
% Group 1: low IQ, low SES      N1=4491
% Group 2: low IQ, high SES     N2=1336
% Group 3: high IQ, low SES     N3=939
% Group 4: high IQ. high SES    N4=4977
%
% References:
% McGaw, B., & Jreskog, K.G. (1971). Factorial invariance of ability 
% measures in groups differing in intelligence and socioeconomic status. 
% British Journal of Mathematical and Statistical Psychology, 24, 154-168.
% 
% Srbom, D. (1974). A general method for studying differences in
% factor means and factor structure between groups. British Journal
% of Mathematical and Statistical Psychology, 27, 229-239.


C12=[0 0.743 0.493 0.228 0.298 0.381 0.294 0.128 0.06 0.15 0.137 0.099
    1.038 0 0.583 0.284 0.351 0.414 0.306 0.144 0.063 0.178 0.135 0.11
    0.788 0.974 0 0.216 0.283 0.318 0.214 0.095 0.424 0.148 0.128 0.113
    0.261 0.286 0.3 0 0.348 0.386 0.039 0.003 -0.023 0.139 0.213 0.041
    0.282 0.359 0.28 0.385 0 0.508 0.197 0.113 0.138 0.254 0.179 0.157
    0.368 0.356 0.363 0.295 0.389 0 0.205 0.131 0.091 0.258 0.228 0.175
    0.32 0.42 0.252 -0.036 0.162 0.186 0 0.396 0.359 0.138 0.102 0.276
    0.08 0.149 0.081 0.01 0.112 0.072 0.302 0 0.377 0.224 0.146 0.338
    0.16 0.236 0.124 -0.048 0.103 0.114 0.498 0.385 0 0.21 0.097 0.291
    -0.013 -0.029 0.002 0.004 0.02 0.007 0.05 0.271 0.063 0 0.427 0.483
    0.074 0.091 0.147 0.255 0.172 0.131 0.048 0.357 0.082 0.384 0 0.47
    0.033 0.018 0.034 -0.041 -0.025 -0.062 0.122 0.379 0.215 0.696 0.425 0];

diagC1=[1.095 0.904 0.776 0.904 0.969 1.303 0.972 1.128 0.926 1.614 1.45 1.336];
diagC2=[1.38 1.41 1.324 0.934 1.127 1.465 1.27 1.255 1.162 2.021 1.737 1.787];

C1=diag(diagC1)+triu(C12)+tril(C12');
C2=diag(diagC2)+tril(C12)+triu(C12');

C34=[0 0.761 0.641 0.273 0.316 0.296 0.192 0.099 0.003 0.079 0.07 0.029
    0.659 0 0.818 0.359 0.408 0.359 0.232 0.134 0.01 0.108 0.108 0.054
    0.562 0.75 0 0.334 0.382 0.331 0.174 0.117 0.003 0.106 0.135 0.08
    0.27 0.303 0.348 0 0.409 0.289 -0.023 0.015 -0.062 0.086 0.151 0.027
    0.283 0.39 0.368 0.461 0 0.378 0.092 0.103 0.034 0.13 0.13 0.07
    0.193 0.238 0.247 0.242 0.303 0 0.127 0.081 0.035 0.085 0.123 0.061
    0.252 0.424 0.281 -0.026 0.16 0.088 0 0.411 0.44 0.069 0.095 0.204
    0.077 0.139 0.134 0.035 0.087 0.049 0.316 0 0.383 0.075 0.115 0.222
    0.157 0.304 0.192 -0.021 0.196 0.079 0.49 0.321 0 0.071 0.061 0.191
    0.013 0.018 0.042 0.06 0.042 0.011 0.015 0.078 0.03 0 0.143 0.169
    0.042 0.041 0.09 0.177 0.093 0.04 -0.024 0.117 0.014 0.123 0 0.201
    -0.001 0.014 0.045 0.028 0.025 0.002 0.084 0.17 0.108 0.143 0.153 0];

diagC3=[0.947 0.968 1.129 1.048 0.986 0.656 0.895 0.9 0.967 0.284 0.524 0.586];
diagC4=[0.882 0.982 1.091 1.095 0.997 0.667 0.972 0.835 1.03 0.307 0.486 0.564];

C3=diag(diagC3)+triu(C34)+tril(C34');
C4=diag(diagC4)+tril(C34)+triu(C34');

clear diag* C12 C34



