function [B,C,G,EV,fp,fptot]=SCA_T3_cov(Sigma,J,K,R1,R2,R3,conv,runs,rotation);

% This function fits the multi-set Tucker3 model, i.e., Simultaneous
% Component Analysis by means of Tucker3 in covariance form. A heuristic 
% algorithm is used to minimize  sum_k ||Xk-Ak*(sum_r(ckr*Gr))*B'||^2 
%
% Input:
%   Sigma=[Sigma1 ... SigmaK]  (JxJ*K) covariance matrices k=1,...,K
%        R1,R2,R3: size of core G, with J>=R2, K>=R3
%   conv: convergence criterion, e.g., 1e-6
%   runs=[run1 run2]: do run1 runs with random start, and first run with rational start if run2=1
%           best solution is kept
%   rotation=[opt1 opt2 opt3 opt4]: parameters for rotation of (A,B,C)*G:
%       opt1=0 : no rotation
%       opt1=1 : orthogonal rotation to simple core G and B
%       opt1=2 : orthogonal rotation to simple core G and B and C
%       opt1=3 : orthogonal rotation to simple core G only
%       opt2,opt3,opt4 : rotate A,B,C or not (yes=1, no=0)
%        
% Output:
%   B (JxR2);                    
%   C (KxR3);   
%   G (R1xR2*R3);    
%   EV (R1xR2*R3);      explained variance due to each core entry
%   fp          fit percentage per k
%   fptot       total fit percentage
%
% References:
% A. Stegeman (2018). Simultaneous component analysis by means of Tucker3.
% Psychometrika, 83, 21-47.
%
% H.A.L. Kiers (1998). Joint orthomax rotation of the core and component 
% matrices resulting from three-mode principal components analysis.
% Journal of Classification, 15, 245-263.


Y=[];
for k=1:K
    Sigmak=Sigma(:,1+(k-1)*J:k*J);
    [Uk,Sk]=svd(Sigmak,0);
    Yk=Uk*sqrt(Sk);
    Y=[Y;Yk'];
end
N=J*ones(K,1);

[A,B,C,G,EV,fp,fptot]=SCA_T3(Y,N,J,K,R1,R2,R3,conv,runs,rotation,0);


    